//
//  CRMultiDelegate.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 10/26/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

//////////////////////////////////////////////////////////////////////
// Event data
//////////////////////////////////////////////////////////////////////
@interface CREventPair : NSObject
{
	id assigned	target;
	SEL			action;
}

@property (assign, nonatomic, readonly) id	target;
@property (assign, nonatomic, readonly) SEL	action;

- (id)initWithTarget:(id)object action:(SEL)method;
+ (id)pairWithTarget:(id)object action:(SEL)method;

@end

//////////////////////////////////////////////////////////////////////
// Multi delegate
//////////////////////////////////////////////////////////////////////
@interface CRMultiDelegate : NSObject<NSCopying>
{
@private
	id	assigned	root;
	NSMutableArray*	items;
	
}

- (id)initWithRoot:(id)rootObject;
- (BOOL)hasListener:(CREventPair *)listener;
- (void)fire;
	
- (void)addListener:(CREventPair *)listener;
- (void)removeListener:(CREventPair *)listener;

@end

//////////////////////////////////////////////////////////////////////
// Aixulliary
//////////////////////////////////////////////////////////////////////
#define CREvent(p, s) [CREventPair pairWithTarget:p action:@selector(s)]